﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace KursBeispiele
{
    public class EigenesForm : Form
    {
        //Eigenes Event deklarieren mit Standard Delegaten
        //in diesem Fall ist der Delegate EventHandler (wie bei Standard-Events)
        public event EventHandler FormMinimized;


        //Eigenes Event deklarieren mit eigenem Delgaten
        //in diesem Fall ist der Delegate EigenerEventHandler mit eigenen EventArgs
        public event EigenerEventHandler FormClicked;

        //Konstruktor unseres eigenen Formulares zum Vererben
        public EigenesForm()
        {
            //Unsere eigenen Ereignisse sollen in diesem Fall auf bereits vorhandenen Ereignissen aufbauen
            this.SizeChanged += new EventHandler(EigenesForm_SizeChanged);

            //dies ist allerdings nur ein Weg - ein bequemer, da man so mehrere (!) Listener auf ein
            //Ereignis legen kann - dies ist in der OOP sehr wichtig
        }

        //Da wir aber vom Formular erben müssen wir nicht die Ereignisse implementieren,
        //sondern können auch direkt die Funktionen die eigentlich dahinter stehen verändern
        protected override void OnMouseClick(MouseEventArgs e)
        {
            if (FormClicked != null)
                FormClicked(this, new EigeneEventArgs(e.Location));

            base.OnMouseClick(e);
        }

        private void EigenesForm_SizeChanged(object sender, EventArgs e)
        {
            //Falls sich die Größe daher geändert hat, weil das Form minimiert wurde
            if (this.WindowState == FormWindowState.Minimized)
                //und der EventHandler wirklich gesetzt, d.h. != null, ist
                if (FormMinimized != null)
                    //dann wird der EventHandler ausgeführt
                    FormMinimized(this, e);
        }
    }

    public class EigeneEventArgs : EventArgs
    {
        //Speicherung einer Koordinate
        Point mouseCoordinates;

        public Point MouseCoordinates
        {
            get { return mouseCoordinates; }
            set { mouseCoordinates = value; }
        }

        //Für unseren eigenen EventArg Typen wollen wir eine Screenkoordinate als Punkt übergeben
        public EigeneEventArgs(Point _coords)
        {
            mouseCoordinates = _coords;
        }
    }

    //Prototyp unseres eigenen Handlers
    public delegate void EigenerEventHandler(object sender, EigeneEventArgs e);
}
